/*******************************************************
Filename		:  	DW_bio_result_criteria_geo.sql
Release 		:  	STORET c2.0
SIR			:  	1502
Description		:  	Creates a centralized form page that allows the user to select 
				all the most common parameters to query BIO Results. This information
				is passed to the DW_result_count procedure.
Author			:  	Joseph Wilson/Christine Tsang
Date			: 	July 22, 2003  -- created based on DW_result_criteria_geo
                        08/06/2003 -- SIR 1532 - Added intent and community sampled selections. -C Tsang
                        08/08/2003 -- SIR 1504 - Pass result_type value to DW_char_select. -CT
                        08/15/2003 -- Replaced the word 'BETA' with 'Biological'. -CT
                        08/22/2003 -- SIR 1500 TIR#1 - Removed hidden variable D_ORG_LIST. -CT
Comments		:  	Calls three pop-up screens that allow the user to enter additional
				information.
**********************************************************/
SET DEF OFF;

CREATE OR REPLACE PROCEDURE DW_BIO_ResultCriteria_GEO AS

--used to generate state list
CURSOR cstate IS
SELECT pk_isn, state_name
FROM DI_GEO_STATE
order by country_code desc, state_name;

program_path  	varchar2(1000) := null;
script_path   	varchar2(1000) := null;
image_path    	varchar2(1000) := null;
page_title    	varchar2(100)  :='Biological Results by Geographic Location';

BEGIN
DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path,
 'document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);adjust_width_n(document.forms[1].D_INTENT_LIST,"~","30~","None","Y");adjust_width_n(document.forms[1].D_COMMUNITY_LIST,"~","30~","None","Y")');
htp.print('<form action="DW_RESULT_COUNT" method=POST>');

-- Geographic location selection
DW_geo_select;

-- Date range selection 
DW_date_select(15);

-- Intent & Community Sampled selections
DW_intent_community_select(39);

-- Characteristics selection
DW_char_select(41,'BIOLOGICAL');

htp.print('
<input type="hidden" name="RESULT_TYPE" value="BIOLOGICAL">
<br>
<center>
<input type="button" value="Continue" tabindex=47 onclick="javascript: submitCriteriaResultGeo();" title="Submit Selection Criteria for processing">&nbsp&nbsp&nbsp
<input type="button" value="Clear Form" tabindex=48 onclick="javascript: deleteAllFromCharList();document.forms[1].reset();ChangeOptionDays(''FROM'',1);ChangeOptionDays(''END'',1);" title="Clear the form">
</center></form>
');
DW_bottom_of_page(21);

END;
/
SHOW ERRORS;
